/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.jmsmvc4swing.jms;

import java.io.Serializable;
import org.fuin.jmsmvc4swing.base.JmsJndiEnvironment;
import org.fuin.jmsmvc4swing.base.ProgressInfo;
import org.fuin.jmsmvc4swing.jms.Data;
import org.fuin.jmsmvc4swing.jms.MessageType;
import org.fuin.jmsmvc4swing.jms.Publisher;
import org.fuin.jmsmvc4swing.jms.ResponseMessageType;

public abstract class MethodResultSender {
    private final JmsJndiEnvironment env;
    private final String topicName;
    private final String methodName;
    private final long id;

    public MethodResultSender(JmsJndiEnvironment env, String topicName, String methodName, long id) {
        this.env = env;
        this.topicName = topicName;
        this.methodName = methodName;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishIntern(MessageType type, Serializable serializable) {
        Publisher publisher = new Publisher(this.env);
        publisher.open(this.topicName);
        try {
            publisher.publish(this.methodName, serializable, this.id, type);
        }
        finally {
            publisher.close();
        }
    }

    protected final void publishResult(Data data) {
        this.publishIntern(ResponseMessageType.RESULT, data);
    }

    public final void started() {
        this.publishIntern(ResponseMessageType.STARTED, null);
    }

    public final void progress(ProgressInfo progressInfo) {
        this.publishIntern(ResponseMessageType.PROGRESS, progressInfo);
    }

    public final void succeded() {
        this.publishIntern(ResponseMessageType.SUCCEDED, null);
    }

    public final void failed(Exception ex) {
        this.publishIntern(ResponseMessageType.FAILED, ex);
    }
}

