/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.jmsmvc4swing.jms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.fuin.jmsmvc4swing.base.Controller;
import org.fuin.jmsmvc4swing.base.IControllerReceiver;
import org.fuin.jmsmvc4swing.base.JmsJndiEnvironment;
import org.fuin.jmsmvc4swing.jms.Data;
import org.fuin.jmsmvc4swing.jms.MethodHandler;
import org.fuin.jmsmvc4swing.jms.RequestMessageType;
import org.fuin.jmsmvc4swing.jms.Subscriber;

public class ControllerReceiver
implements MessageListener,
IControllerReceiver {
    private final String topicName;
    private final Controller ctrl;
    private final Map<String, MethodHandler> handlerMap;
    private final Subscriber subscriber;

    public ControllerReceiver(JmsJndiEnvironment env, String topicName, Controller ctrl) {
        this.ctrl = ctrl;
        this.handlerMap = new HashMap<String, MethodHandler>();
        this.subscriber = new Subscriber(env);
        this.topicName = topicName;
    }

    public final String getTopicName() {
        return this.topicName;
    }

    public final void start() {
        this.subscriber.open(this.topicName, null, null, RequestMessageType.START, (MessageListener)this);
    }

    private void handle(String methodName, Data args, long id) {
        MethodHandler handler = this.handlerMap.get(methodName);
        if (handler == null) {
            System.out.println("ERROR - Unknown method! [method=" + methodName + ", args=" + args + ", " + "id" + "=" + id + "]");
        } else {
            handler.handle(this.ctrl, this.getTopicName(), args, id);
        }
    }

    public final void onMessage(Message message) {
        try {
            ObjectMessage om;
            Serializable obj;
            if (!(message instanceof ObjectMessage)) {
                System.out.println("ERROR - No object message! [message=" + message + "]");
            }
            if (!((obj = (om = (ObjectMessage)message).getObject()) instanceof Data)) {
                System.out.println("ERROR - No argument! [object=" + obj + "]");
            }
            this.handle(om.getStringProperty("method"), (Data)obj, om.getLongProperty("id"));
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
    }

    public final boolean isStopped() {
        return this.subscriber.isClosed();
    }

    public final void stop() {
        this.subscriber.close();
    }

    public final void addRequestHandler(MethodHandler handler) {
        this.handlerMap.put(handler.getMethodName(), handler);
    }
}

