/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.jmsmvc4swing.model;

import java.util.List;

import org.fuin.jmsmvc4swing.base.Controller;
import org.fuin.jmsmvc4swing.base.JmsJndiEnvironment;
import org.fuin.jmsmvc4swing.jms.ControllerReceiver;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgConstructor;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;

/**
 * Generates a <code>ControllerReceiver</code> implementation.
 * 
 * @param <I>
 *            The controller interface the created class is for.
 */
public final class ControllerReceiverGenerator<I extends Controller> extends
        AbstractGenerator<I, ControllerReceiver> {

    /**
     * Constructor.
     * 
     * @param pool
     *            Class pool to use.
     * @param model
     *            Controller model.
     * @param basePackage
     *            Base package.
     */
    public ControllerReceiverGenerator(final SgClassPool pool, final ControllerModel<I> model,
            final String basePackage) {
        super(pool, model, basePackage, model.getPackageName(), model.getSimpleName()
                + "Receiver");
    }

    private void addConstructor(final SgClass clasz) {

        final SgConstructor constructor = new SgConstructor(clasz);
        // Adds the arguments implicitly to the constructor
        new SgArgument(constructor, SgClass.create(getPool(), JmsJndiEnvironment.class), "env");
        new SgArgument(constructor, SgClass.create(getPool(), String.class), "topicName");
        new SgArgument(constructor, SgClass.create(getPool(), Controller.class), "ctrl");

        constructor.addBodyLine("super(env, topicName, ctrl);");
        final List<SgMethod> methods = getModel().getControllerInterface().getMethods();
        for (int i = 0; i < methods.size(); i++) {
            final String packageName = SgUtils.concatPackages(getDestPackage(), methods.get(i)
                    .getNameAsPackage());
            constructor
                    .addBodyLine(("addRequestHandler(new " + packageName + ".MethodHandler(env));"));
        }
        clasz.addConstructor(constructor);

    }

    /**
     * Create the model class based on the interface informations.
     * 
     * @return Model class.
     */
    public final SgClass createModelClass() {

        // Create class definition
        final SgClass parent = SgClass.create(getPool(), ControllerReceiver.class);
        final SgClass clasz = new SgClass("public", getDestPackage(), getSimpleDestClass(),
                parent, false, null);

        // Add constructor definition
        addConstructor(clasz);

        getPool().put(clasz);

        return clasz;
    }

}
