/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.jmsmvc4swing.jms;

import org.fuin.jmsmvc4swing.base.BusyConfigurable;
import org.fuin.jmsmvc4swing.base.Cancelable;
import org.fuin.jmsmvc4swing.base.ControllerResultListener;

/**
 * Sends a JMS message to the controller by selecting the appropriate
 * MethodCallSender.
 */
public abstract class ControllerSender {

    /**
     * {@inheritDoc}
     */
    protected final void configureBusyMode(final MethodCallSender methodCallSender,
            final ControllerResultListener listener) {
        if (listener instanceof BusyConfigurable) {
            final BusyConfigurable configurable = (BusyConfigurable) listener;
            if (methodCallSender instanceof Cancelable) {
                configurable.configure((Cancelable) methodCallSender, methodCallSender
                        .isDeterminate());
            } else {
                configurable.configure(null, methodCallSender.isDeterminate());
            }
        }
    }

}
