/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.jmsmvc4swing.jms;

import org.fuin.jmsmvc4swing.jms.MessageType;

public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("Cannot create an instance of this class!");
    }

    public static String getTypeExpr(MessageType type) {
        return "type='" + type.getName() + "'";
    }

    public static String getTypeExpr(MessageType[] type) {
        if (type == null || type.length == 0) {
            return "";
        }
        if (type.length == 1) {
            return Utils.getTypeExpr(type[0]);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < type.length; ++i) {
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append(Utils.getTypeExpr(type[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getMethodExpr(String methodName) {
        return "method='" + methodName + "'";
    }

    public static String getIdExpr(long id) {
        return "id='" + id + "'";
    }

    public static String getMessageSelector(String methodName, Long id, MessageType type) {
        return Utils.getMessageSelector(methodName, id, new MessageType[]{type});
    }

    public static String getMessageSelector(String methodName, Long id, MessageType[] type) {
        StringBuffer sb = new StringBuffer();
        if (methodName != null) {
            Utils.append(sb, Utils.getMethodExpr(methodName));
        }
        if (id != null) {
            Utils.append(sb, Utils.getIdExpr(id));
        }
        if (type != null) {
            Utils.append(sb, Utils.getTypeExpr(type));
        }
        return sb.toString();
    }

    private static void append(StringBuffer sb, String expr) {
        if (sb.length() > 0) {
            sb.append(" AND ");
        }
        sb.append(expr);
    }
}

