/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.jmsmvc4swing.base;

import java.io.Serializable;

/**
 * Progress information sent by the controller.
 */
public final class ProgressInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    private final String message;

    private final int extent;

    private final int maximum;

    private final int minimum;

    private final int value;

    /**
     * Constructor.
     * 
     * @param message
     *            Text message or empty String.
     * @param minimum
     *            Minimum or zero if not used.
     * @param value
     *            Value or zero if not used.
     * @param extent
     *            Extent or zero if not used.
     * @param maximum
     *            Maximum or zero if not used.
     */
    public ProgressInfo(final String message, final int minimum, final int value,
            final int extent, final int maximum) {
        super();
        this.message = message;
        this.minimum = minimum;
        this.value = value;
        this.extent = extent;
        this.maximum = maximum;
    }

    /**
     * Returns a text message or empty String.
     * 
     * @return Message or empty String.
     */
    public final String getMessage() {
        return message;
    }

    /**
     * Returns the extent.
     * 
     * @return Extend or zero.
     */
    public final int getExtent() {
        return extent;
    }

    /**
     * Returns the maximum.
     * 
     * @return Maximum or zero.
     */
    public final int getMaximum() {
        return maximum;
    }

    /**
     * Returns the minimum.
     * 
     * @return Minimum or zero.
     */
    public final int getMinimum() {
        return minimum;
    }

    /**
     * Returns the value.
     * 
     * @return Value or zero.
     */
    public final int getValue() {
        return value;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public final String toString() {
        return getClass().getSimpleName() + "{" + "message=" + message + ", " + "minimum="
                + minimum + ", " + "value=" + value + ", " + "extent=" + extent + ", "
                + "maximum=" + maximum + "}";
    }

}
