/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.jmsmvc4swing.base;

import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.naming.Context;

/**
 * Environment for using JMS and JNDI.
 */
public interface JmsJndiEnvironment {

    /**
     * Return the naming context.
     * 
     * @return Naming context.
     */
    public Context getContext();

    /**
     * Creates a topic for a given name.
     * 
     * @param name
     *            Name of the topic to create.
     * 
     * @return New topic instance.
     */
    public Topic getTopic(String name);

    /**
     * Create a connection to the JMS provider and start it.
     */
    public void open();

    /**
     * Returns the information if the connection to the JMS provider is active.
     * 
     * @return If the connection is open and started TRUE else FALSE.
     */
    public boolean isOpen();

    /**
     * Returns the JMS provider connection. Do only use if <code>isOpen()</code>
     * returns TRUE!
     * 
     * @return Active connection.
     */
    public TopicConnection getConnection();

    /**
     * Close the JMS connection to the provider.
     */
    public void close();

}
