/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.jmsmvc4swing.base;

/**
 * A <code>ControllerSender</code> and <code>ControllerReceiver</code> pair for
 * use in the Application.
 * 
 * @param <T>
 *            A controller interface.
 */
public class ControllerPair<T extends Controller> {

    private final T sender;

    private final IControllerReceiver receiver;

    /**
     * Constructor.
     * 
     * @param sender
     *            Sender implementation created with byte code generation.
     * @param receiver
     *            Receiver implementation created with byte code generation.
     */
    public ControllerPair(final T sender, final IControllerReceiver receiver) {
        super();
        this.sender = sender;
        this.receiver = receiver;
    }

    /**
     * Returns the "Sender" implementation.
     * 
     * @return Implementation created with byte code generation.
     */
    public final T getSender() {
        return sender;
    }

    /**
     * Returns the receiver implementation.
     * 
     * @return Implementation created with byte code generation.
     */
    public final IControllerReceiver getReceiver() {
        return receiver;
    }

}
