/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.jmsmvc4swing.jms;

import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.fuin.jmsmvc4swing.base.JmsJndiEnvironment;
import org.fuin.jmsmvc4swing.jms.MessageType;
import org.fuin.jmsmvc4swing.jms.Utils;

public class Subscriber {
    private final JmsJndiEnvironment env;
    private TopicSession session;
    private TopicSubscriber subscriber;

    public Subscriber(JmsJndiEnvironment env) {
        this.env = env;
    }

    public final void open(String topicName, String methodName, Long id, MessageType type, MessageListener listener) {
        this.open(topicName, methodName, id, new MessageType[]{type}, listener);
    }

    public final void open(String topicName, String methodName, Long id, MessageType[] type, MessageListener listener) {
        try {
            this.session = this.env.getConnection().createTopicSession(false, 1);
            Topic topic = this.env.getTopic(topicName);
            String messageSelector = Utils.getMessageSelector(methodName, id, type);
            this.subscriber = messageSelector == null ? this.session.createSubscriber(topic) : this.session.createSubscriber(topic, messageSelector, false);
            this.subscriber.setMessageListener(listener);
        }
        catch (JMSException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final boolean isOpen() {
        return this.session != null;
    }

    public final boolean isClosed() {
        return this.session == null;
    }

    public final void close() {
        if (this.isOpen()) {
            try {
                this.session.close();
                this.session = null;
                this.subscriber = null;
            }
            catch (JMSException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

