/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.jmsmvc4swing.model;

import org.fuin.jmsmvc4swing.base.Controller;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;

/**
 * Generates classes depending on a method.
 * 
 * @param <I>
 *            The controller interface the created class is for.
 * @param <T>
 *            Type of the class the generator will create.
 */
public abstract class AbstractMethodGenerator<I extends Controller, T> extends
        AbstractGenerator<I, T> {

    private final SgMethod intfMethod;

    /**
     * Constructor.
     * 
     * @param pool
     *            Class pool to use.
     * @param model
     *            Controller model.
     * @param basePackage
     *            Base package.
     * @param intfMethod
     *            Method from the interface the class depends on.
     * @param simpleDestClass
     *            Name of the destination class (without package).
     */
    public AbstractMethodGenerator(final SgClassPool pool, final ControllerModel<I> model,
            final String basePackage, final SgMethod intfMethod, final String simpleDestClass) {

        super(pool, model, basePackage, SgUtils.concatPackages(model.getPackageName(),
                intfMethod.getNameAsPackage()), simpleDestClass);

        if (intfMethod == null) {
            throw new IllegalArgumentException("The argument 'intfMethod' cannot be null!");
        }
        this.intfMethod = intfMethod;

    }

    /**
     * Returns the method this class depends on.
     * 
     * @return Interface method.
     */
    protected final SgMethod getIntfMethod() {
        return intfMethod;
    }

}
