/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.jmsmvc4swing.base;

/**
 * Receives controller results and does nothing by default. Can be overwritten
 * to receive the events you're interested in.
 */
public class ControllerResultAdapter implements ControllerResultListener {

    /**
     * {@inheritDoc}
     */
    public void started() {
        // Do nothing by default
    }

    /**
     * {@inheritDoc}
     */
    public void progress(final ProgressInfo progressInfo) {
        // Do nothing by default
    }

    /**
     * {@inheritDoc}
     */
    public void failed(final Exception ex) {
        // Do nothing by default
    }

    /**
     * {@inheritDoc}
     */
    public void succeded() {
        // Do nothing by default
    }

}
