/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.jmsmvc4swing.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.fuin.jmsmvc4swing.base.Controller;
import org.fuin.jmsmvc4swing.base.ControllerPair;
import org.fuin.jmsmvc4swing.base.ControllerResultListener;
import org.fuin.jmsmvc4swing.base.JmsJndiEnvironment;
import org.fuin.jmsmvc4swing.jms.ControllerReceiver;
import org.fuin.jmsmvc4swing.jms.ControllerSender;
import org.fuin.jmsmvc4swing.model.ArgumentsGenerator;
import org.fuin.jmsmvc4swing.model.ControllerReceiverGenerator;
import org.fuin.jmsmvc4swing.model.ControllerSenderGenerator;
import org.fuin.jmsmvc4swing.model.MethodCallSenderGenerator;
import org.fuin.jmsmvc4swing.model.MethodHandlerGenerator;
import org.fuin.jmsmvc4swing.model.MethodResultReceiverGenerator;
import org.fuin.jmsmvc4swing.model.MethodResultSenderGenerator;
import org.fuin.jmsmvc4swing.model.ResultGenerator;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControllerModel<T extends Controller> {
    private final ByteCodeGenerator generator;
    private final SgClassPool pool;
    private final String basePackage;
    private final SgClass ctrlInterface;
    private final List<SgClass> classes;

    public ControllerModel(Class controllerInterface) {
        this(controllerInterface.getPackage().getName(), controllerInterface, null);
    }

    public ControllerModel(String basePackage, Class controllerInterface) {
        this(basePackage, controllerInterface, null);
    }

    public ControllerModel(String basePackage, Class controllerInterface, ByteCodeGenerator generator) {
        if (basePackage == null) {
            throw new IllegalArgumentException("The argument 'basePackage' cannot be null!");
        }
        this.basePackage = basePackage;
        if (controllerInterface == null) {
            throw new IllegalArgumentException("The argument 'controllerInterface' cannot be null!");
        }
        this.classes = new ArrayList<SgClass>();
        this.pool = new SgClassPool();
        this.ctrlInterface = SgClass.create((SgClassPool)this.pool, (Class)controllerInterface);
        this.generator = generator == null ? new ByteCodeGenerator() : generator;
        this.check();
        this.parse();
    }

    private void check() {
        if (!this.ctrlInterface.isInterface()) {
            throw new IllegalArgumentException("Only interfaces are allowed for argument 'controllerInterface'! [" + this.ctrlInterface.getName() + " is not an interface!]");
        }
        List methods = this.ctrlInterface.getMethods();
        if (methods.size() == 0) {
            throw new IllegalArgumentException("There are no methods within the interface! [" + this.ctrlInterface.getName() + "]");
        }
        List<SgClass> listenerInterfaces = ControllerModel.getControllerResultListener(this.ctrlInterface.getClasses());
        if (methods.size() != listenerInterfaces.size()) {
            throw new IllegalArgumentException("There number of interfaces (" + listenerInterfaces.size() + ") is not equal to the number of methods (" + methods.size() + ")!");
        }
        int i = 0;
        while (i < methods.size()) {
            SgMethod method = (SgMethod)methods.get(i);
            SgArgument lastArgument = method.getLastArgument();
            if (lastArgument == null) {
                throw new IllegalArgumentException("The method '" + method.getName() + "' has no arguments but at least a " + "'ControllerResultListener' is mandantory!");
            }
            String listenerName = String.valueOf(this.ctrlInterface.getName()) + "$" + SgUtils.firstCharUpper((String)method.getName()) + "Listener";
            if (!lastArgument.getType().getName().equals(listenerName)) {
                throw new IllegalArgumentException("The last argument of method " + method.getName() + " is type '" + lastArgument.getType().getName() + "' and not '" + listenerName + "' as expected!");
            }
            SgClass listenerClass = this.ctrlInterface.findClassByName(listenerName);
            if (listenerClass == null) {
                throw new IllegalArgumentException("Interface " + listenerName + " not found!");
            }
            ++i;
        }
    }

    public final List<SgClass> getModelClasses() {
        return this.classes;
    }

    public final SgClass getControllerInterface() {
        return this.ctrlInterface;
    }

    public final String getPackageName() {
        return this.ctrlInterface.getSimpleNameAsPackage();
    }

    public final String getSimpleName() {
        return this.ctrlInterface.getSimpleName();
    }

    private void parse() {
        SgMethod intfMethod;
        List intfMethods = this.ctrlInterface.getMethods();
        int i = 0;
        while (i < intfMethods.size()) {
            intfMethod = (SgMethod)intfMethods.get(i);
            ArgumentsGenerator argsGen = new ArgumentsGenerator(this.pool, this, this.basePackage, intfMethod);
            this.classes.add(argsGen.createModelClass());
            String listenerName = String.valueOf(this.ctrlInterface.getName()) + "$" + SgUtils.firstCharUpper((String)intfMethod.getName()) + "Listener";
            SgClass listenerClass = this.ctrlInterface.findClassByName(listenerName);
            List listenerMethods = listenerClass.getMethods();
            int j = 0;
            while (j < listenerMethods.size()) {
                SgMethod listenerMethod = (SgMethod)listenerMethods.get(j);
                ResultGenerator resultGen = new ResultGenerator(this.pool, this, this.basePackage, listenerMethod);
                this.classes.add(resultGen.createModelClass());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < intfMethods.size()) {
            intfMethod = (SgMethod)intfMethods.get(i);
            MethodResultSenderGenerator mrsGen = new MethodResultSenderGenerator(this.pool, this, this.basePackage, intfMethod);
            this.classes.add(mrsGen.createModelClass());
            MethodResultReceiverGenerator mrrGen = new MethodResultReceiverGenerator(this.pool, this, this.basePackage, intfMethod);
            this.classes.add(mrrGen.createModelClass());
            ++i;
        }
        i = 0;
        while (i < intfMethods.size()) {
            intfMethod = (SgMethod)intfMethods.get(i);
            MethodHandlerGenerator mhGen = new MethodHandlerGenerator(this.pool, this, this.basePackage, intfMethod);
            this.classes.add(mhGen.createModelClass());
            MethodCallSenderGenerator mcsGen = new MethodCallSenderGenerator(this.pool, this, this.basePackage, intfMethod);
            this.classes.add(mcsGen.createModelClass());
            ++i;
        }
        ControllerReceiverGenerator crGen = new ControllerReceiverGenerator(this.pool, this, this.basePackage);
        this.classes.add(crGen.createModelClass());
        ControllerSenderGenerator csGen = new ControllerSenderGenerator(this.pool, this, this.basePackage);
        this.classes.add(csGen.createModelClass());
    }

    public final ControllerPair<T> createOnTheFly(JmsJndiEnvironment env, String topicName, Controller ctrl) {
        Class senderClass = null;
        Class receiverClass = null;
        int i = 0;
        while (i < this.classes.size()) {
            SgClass modelClass = this.classes.get(i);
            Class clasz = this.generator.createClass(modelClass);
            if (modelClass.getSuperClass() != null) {
                if (modelClass.getSuperClass().getName().equals(ControllerReceiver.class.getName())) {
                    receiverClass = clasz;
                } else if (modelClass.getSuperClass().getName().equals(ControllerSender.class.getName())) {
                    senderClass = clasz;
                }
            }
            ++i;
        }
        if (senderClass == null) {
            throw new IllegalStateException("No 'sender' found!");
        }
        if (receiverClass == null) {
            throw new IllegalStateException("No 'receiver' found!");
        }
        ControllerSender sender = (ControllerSender)this.generator.createInstance(senderClass, new Class[]{JmsJndiEnvironment.class, String.class}, new Object[]{env, topicName});
        ControllerReceiver receiver = (ControllerReceiver)this.generator.createInstance(receiverClass, new Class[]{JmsJndiEnvironment.class, String.class, Controller.class}, new Object[]{env, topicName, ctrl});
        return new ControllerPair<Controller>((Controller)((Object)sender), receiver);
    }

    public void createSource(File srcDir) throws IOException {
        int i = 0;
        while (i < this.classes.size()) {
            SgClass modelClass = this.classes.get(i);
            String filename = modelClass.getNameAsSrcFilename();
            File srcFile = new File(srcDir, filename);
            srcFile.getParentFile().getCanonicalFile().mkdirs();
            BufferedWriter writer = new BufferedWriter(new FileWriter(srcFile));
            try {
                writer.write(modelClass.toString());
            }
            finally {
                ((Writer)writer).close();
            }
            ++i;
        }
    }

    private static List<SgClass> getControllerResultListener(List<SgClass> classes) {
        ArrayList<SgClass> listener = new ArrayList<SgClass>();
        int i = 0;
        while (i < classes.size()) {
            List interfaces = classes.get(i).getInterfaces();
            int j = 0;
            while (j < interfaces.size()) {
                if (((SgClass)interfaces.get(j)).getName().equals(ControllerResultListener.class.getName())) {
                    listener.add(classes.get(i));
                }
                ++j;
            }
            ++i;
        }
        return listener;
    }

    public final ByteCodeGenerator getGenerator() {
        return this.generator;
    }

    public final SgClassPool getPool() {
        return this.pool;
    }
}

