/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.jmsmvc4swing.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.fuin.jmsmvc4swing.base.JmsJndiEnvironment;
import org.fuin.jmsmvc4swing.jms.MessageType;
import org.fuin.jmsmvc4swing.jms.Utils;

public final class Publisher {
    private final JmsJndiEnvironment env;
    private TopicSession session;
    private TopicPublisher publisher;

    public Publisher(JmsJndiEnvironment env) {
        this.env = env;
    }

    public final void open(String topicName) {
        try {
            this.session = this.env.getConnection().createTopicSession(false, 1);
            Topic topic = this.env.getTopic(topicName);
            this.publisher = this.session.createPublisher(topic);
        }
        catch (JMSException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final boolean isOpen() {
        return this.session != null;
    }

    public final boolean isClosed() {
        return this.session == null;
    }

    public final void close() {
        if (this.isOpen()) {
            try {
                this.session.close();
                this.session = null;
                this.publisher = null;
            }
            catch (JMSException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public final void publish(String methodName, Serializable data, long id, MessageType type) {
        try {
            ObjectMessage message = this.session.createObjectMessage();
            message.setStringProperty("method", methodName);
            message.setStringProperty("id", "" + id);
            message.setStringProperty("type", type.getName());
            if (data != null) {
                message.setObject(data);
            }
            System.out.println("PUBLISH [" + this.publisher.getTopic().getTopicName() + "] " + Utils.getMessageSelector(methodName, (Long)id, type) + " / DATA=" + data);
            this.publisher.publish((Message)message);
        }
        catch (JMSException ex) {
            throw new RuntimeException(ex);
        }
    }
}

