/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.jmsmvc4swing.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.fuin.jmsmvc4swing.base.ControllerResultListener;
import org.fuin.jmsmvc4swing.base.JmsJndiEnvironment;
import org.fuin.jmsmvc4swing.base.ProgressInfo;
import org.fuin.jmsmvc4swing.jms.Data;
import org.fuin.jmsmvc4swing.jms.ResponseMessageType;
import org.fuin.jmsmvc4swing.jms.Subscriber;

public abstract class MethodResultReceiver
implements MessageListener {
    private final Subscriber subscriber;
    private final String topicName;
    private final String methodName;
    private final long id;
    private final ControllerResultListener listener;

    public MethodResultReceiver(JmsJndiEnvironment env, String topicName, String methodName, long id, ControllerResultListener listener) {
        this.topicName = topicName;
        this.subscriber = new Subscriber(env);
        this.methodName = methodName;
        this.id = id;
        this.listener = listener;
    }

    public final void subscribe() {
        this.subscriber.open(this.topicName, this.methodName, (Long)this.id, ResponseMessageType.getAll(), (MessageListener)this);
    }

    public final void onMessage(Message message) {
        if (!(message instanceof ObjectMessage)) {
            System.out.println("ERROR - No object message! [message=" + message + "]");
        }
        try {
            ObjectMessage msg = (ObjectMessage)message;
            ResponseMessageType type = ResponseMessageType.forName(msg.getStringProperty("type"));
            if (type.equals(ResponseMessageType.STARTED)) {
                this.listener.started();
            } else if (type.equals(ResponseMessageType.PROGRESS)) {
                this.listener.progress((ProgressInfo)msg.getObject());
            } else if (type.equals(ResponseMessageType.RESULT)) {
                this.handleResult((Data)msg.getObject());
            } else if (type.equals(ResponseMessageType.SUCCEDED)) {
                this.subscriber.close();
                this.listener.succeded();
            } else if (type.equals(ResponseMessageType.FAILED)) {
                this.subscriber.close();
                this.listener.failed((Exception)msg.getObject());
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
    }

    public final boolean isCancelled() {
        return this.subscriber.isClosed();
    }

    public final void cancel() {
        System.out.println("CANCEL");
        this.subscriber.close();
    }

    protected abstract void handleResult(Data var1);
}

