/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.jmsmvc4swing.base;

import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.fuin.jmsmvc4swing.base.JmsJndiEnvironment;

public final class JmsJndiEnvironmentImpl
implements JmsJndiEnvironment {
    public static final String CONTEXT = "dynamicTopics";
    private final Context context;
    private TopicConnection connection;
    private final String topicConnectionFactoryKey;

    public JmsJndiEnvironmentImpl(Context context, String topicConnectionFactoryKey) {
        this.context = context;
        this.topicConnectionFactoryKey = topicConnectionFactoryKey;
    }

    public final void open() {
        try {
            TopicConnectionFactory factory = (TopicConnectionFactory)this.context.lookup(this.topicConnectionFactoryKey);
            this.connection = factory.createTopicConnection();
            this.connection.start();
        }
        catch (JMSException ex) {
            throw new RuntimeException(ex);
        }
        catch (NamingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final boolean isOpen() {
        return this.connection != null;
    }

    public final void close() {
        if (this.isOpen()) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            this.connection = null;
        }
    }

    public final Topic getTopic(String name) {
        try {
            return (Topic)this.context.lookup("dynamicTopics/" + name);
        }
        catch (NamingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final TopicConnection getConnection() {
        return this.connection;
    }

    public final Context getContext() {
        return this.context;
    }
}

