/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.utils4j.filter;

import java.util.ArrayList;
import org.fuin.examples.utils4j.filter.Person;
import org.fuin.utils4j.filter.AndFilter;
import org.fuin.utils4j.filter.BooleanPropertyFilter;
import org.fuin.utils4j.filter.ComparableFilter;
import org.fuin.utils4j.filter.Filter;
import org.fuin.utils4j.filter.IntegerPropertyFilter;
import org.fuin.utils4j.filter.OrFilter;

public final class SimpleFilterExample {
    public final void execute() {
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(new Person(1, "Peter", "Parker", false));
        persons.add(new Person(2, "Mary Jane", "Watson", false));
        persons.add(new Person(3, "Harry", "Osborn", false));
        persons.add(new Person(4, "John", "Doe", true));
        persons.add(new Person(5, "Jane", "Doe", true));
        BooleanPropertyFilter unknownFilter = new BooleanPropertyFilter("unknown", Boolean.valueOf(true));
        IntegerPropertyFilter minIdFilter = new IntegerPropertyFilter("id", ComparableFilter.Operator.GTE, Integer.valueOf(1));
        IntegerPropertyFilter maxIdFilter = new IntegerPropertyFilter("id", ComparableFilter.Operator.LTE, Integer.valueOf(2));
        AndFilter minMaxFilter = new AndFilter((Filter)minIdFilter, (Filter)maxIdFilter);
        OrFilter orFilter = new OrFilter((Filter)minMaxFilter, (Filter)unknownFilter);
        System.out.println("FILTER:");
        System.out.println(orFilter);
        System.out.println();
        System.out.println("RESULT:");
        int i = 0;
        while (i < persons.size()) {
            Person person = (Person)persons.get(i);
            if (orFilter.complies((Object)person)) {
                System.out.println(person);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        new SimpleFilterExample().execute();
    }
}

