/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.apps4swing;

import java.io.File;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.fuin.apps4j.base.CanceledException;
import org.fuin.apps4j.base.Controller;
import org.fuin.apps4j.base.View;
import org.fuin.apps4j.base.WindowManager;
import org.fuin.apps4swing.JFrameWindowManager;
import org.fuin.apps4swing.ManualMvcContext;
import org.fuin.apps4swing.MvcBundle;
import org.fuin.examples.apps4swing.LoginPanel;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginControllerImpl;
import org.fuin.examples.apps4xxxxx.LoginModule;
import org.fuin.examples.apps4xxxxx.LoginView;
import org.fuin.utils4swing.common.Utils4Swing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoginDialogBetterApproach {
    private static final Logger LOG = LoggerFactory.getLogger(LoginDialogBetterApproach.class);

    public final void start() {
        LOG.info("start()");
        try {
            Utils4Swing.initSystemLookAndFeel();
            LoginPanel view = new LoginPanel();
            LoginControllerImpl ctrl = new LoginControllerImpl();
            MvcBundle<LoginView, LoginController, LoginModule> mvcBundle = this.createMvcBundle(view, ctrl);
            ManualMvcContext mvcContext = this.createMvcContext(mvcBundle, ctrl, view);
            LoginModule module = (LoginModule)mvcContext.getModuleImpl(mvcBundle);
            try {
                String username = module.login("john");
                LOG.info("Login successful: " + username);
            }
            catch (CanceledException ex) {
                LOG.info(ex.getMessage());
                LOG.info("exit(1)");
                System.exit(1);
            }
            LOG.info("exit(0)");
            System.exit(0);
        }
        catch (Throwable t) {
            LOG.error("exit(2)", t);
            System.exit(2);
        }
    }

    private ManualMvcContext createMvcContext(MvcBundle<LoginView, LoginController, LoginModule> mvcBundle, LoginControllerImpl ctrl, LoginPanel view) {
        ManualMvcContext mvcContext = new ManualMvcContext();
        mvcContext.setBundles(new MvcBundle[]{mvcBundle});
        mvcContext.init();
        ctrl.setWindowManager((WindowManager)new JFrameWindowManager());
        ctrl.setView((LoginView)mvcContext.getToViewDispatcher(mvcBundle));
        view.setController((LoginController)mvcContext.getToControllerDispatcher(mvcBundle));
        return mvcContext;
    }

    private MvcBundle<LoginView, LoginController, LoginModule> createMvcBundle(LoginPanel view, LoginControllerImpl ctrl) {
        MvcBundle mvcBundle = new MvcBundle();
        mvcBundle.setName("Login");
        mvcBundle.setPkg("org.fuin.examples.apps4swing.generated");
        mvcBundle.setCtrlIntf(LoginController.class);
        mvcBundle.setViewIntf(LoginView.class);
        mvcBundle.setModuleIntf(LoginModule.class);
        mvcBundle.setCtrlImpl((Controller)ctrl);
        mvcBundle.setViewImpl((View)view);
        mvcBundle.setSrcDir(new File("C:/tmp/src-gen"));
        return mvcBundle;
    }

    private static void configureLog4J() {
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, A1");
        props.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.A1.layout.ConversionPattern", "%d{HH:mm:ss,SSS} [%-20t] %-5p %-40c{1} - %m%n");
        PropertyConfigurator.configure((Properties)props);
    }

    public static void main(String[] args) {
        LoginDialogBetterApproach.configureLog4J();
        new LoginDialogBetterApproach().start();
    }
}

