/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.jmsmvc4swing;

import java.awt.Container;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.fuin.aspects4swing.InvokeAndWait;
import org.fuin.aspects4swing.InvokeLater;
import org.fuin.examples.jmsmvc4swing.AddressController;
import org.fuin.examples.jmsmvc4swing.AddressControllerImpl;
import org.fuin.examples.jmsmvc4swing.AddressListPanel;
import org.fuin.jmsmvc4swing.base.Controller;
import org.fuin.jmsmvc4swing.base.ControllerPair;
import org.fuin.jmsmvc4swing.base.IControllerReceiver;
import org.fuin.jmsmvc4swing.base.JmsJndiEnvironment;
import org.fuin.jmsmvc4swing.base.JmsJndiEnvironmentImpl;
import org.fuin.jmsmvc4swing.model.ControllerModel;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.utils4swing.common.FramePositioner;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;

public class AddressManager {
    private final JmsJndiEnvironment env;
    private AddressController sender;
    private IControllerReceiver receiver;
    private final ControllerModel<AddressController> controllerModel;

    static {
        System.setSecurityManager(null);
    }

    public AddressManager(JmsJndiEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException("The argument 'env' cannot be null!");
        }
        this.env = env;
        this.controllerModel = new ControllerModel("org.fuin.jaddr.onthefly", AddressController.class, ByteCodeGenerator.createWithCurrentThreadContextClassLoader());
        this.init();
    }

    private static void registerShutdownHook(final JmsJndiEnvironment env) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                env.close();
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(runnable));
    }

    @InvokeLater
    public final void execute() {
        AddressListPanel panel = new AddressListPanel(this.controllerModel.getPool(), this.controllerModel.getGenerator());
        panel.setAddressController(this.sender);
        Utils4Swing.createShowAndPosition((String)"JAddressManager", (Container)panel.getView(), (boolean)true, (boolean)true, (FramePositioner)new ScreenCenterPositioner());
    }

    private void init() {
        String topicName = AddressController.class.getName();
        ControllerPair result = this.controllerModel.createOnTheFly(this.env, topicName, (Controller)new AddressControllerImpl());
        this.receiver = result.getReceiver();
        System.out.println("RECEIVER=" + this.receiver);
        this.receiver.start();
        this.sender = (AddressController)result.getSender();
        System.out.println("SENDER=" + this.sender);
    }

    @InvokeAndWait
    private static void initLookAndFeel() {
        Utils4Swing.initSystemLookAndFeel();
    }

    public static void main(String[] args) throws NamingException {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "net.walend.somnifugi.SomniTopicContextFactory");
        String topicConnectionFactoryKey = "ConnectionFactory";
        JmsJndiEnvironmentImpl env = new JmsJndiEnvironmentImpl((Context)new InitialContext(props), "ConnectionFactory");
        env.open();
        AddressManager.registerShutdownHook((JmsJndiEnvironment)env);
        AddressManager.initLookAndFeel();
        new AddressManager((JmsJndiEnvironment)env).execute();
    }
}

