/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.jmsmvc4swing;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import com.jeta.forms.components.panel.FormPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.divxdede.swing.busy.JBusyComponent;
import org.fuin.aspects4swing.InvokeAndWait;
import org.fuin.examples.jmsmvc4swing.Address;
import org.fuin.examples.jmsmvc4swing.AddressController;
import org.fuin.jmsmvc4swing.base.ControllerResultBusyAdapter;
import org.fuin.jmsmvc4swing.base.View;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.glazedlists.TableFormatCreator;
import org.fuin.utils4swing.glazedlists.TableFormatExt;

public final class AddressListPanel
extends FormPanel
implements View {
    private static final long serialVersionUID = 1L;
    private final SortedList<Address> addresses = new SortedList((EventList)new BasicEventList());
    private final EventSelectionModel<Address> addressSelection = new EventSelectionModel(this.addresses);
    private final JBusyComponent<AddressListPanel> busyComponent;
    private AddressController addressController;

    public AddressListPanel(SgClassPool pool, ByteCodeGenerator generator) {
        super(String.valueOf(Utils4J.getPackagePath(AddressListPanel.class)) + "/AddressListPanel.jfrm");
        this.init(pool, generator);
        this.busyComponent = new JBusyComponent();
        this.busyComponent.setView((JComponent)((Object)this));
    }

    private void init(SgClassPool classPool, ByteCodeGenerator generator) {
        this.setPreferredSize(new Dimension(600, 600));
        TableFormatCreator creator = new TableFormatCreator(classPool, generator);
        TableFormatExt tableFormat = creator.create(Address.class, Locale.ENGLISH);
        final JTable table = this.getTableAddresses();
        table.setModel((TableModel)new EventTableModel(this.addresses, (TableFormat)tableFormat));
        table.setAutoResizeMode(0);
        table.setSelectionMode(0);
        TableColumnModel colModel = table.getColumnModel();
        int i = 0;
        while (i < tableFormat.getColumnCount()) {
            TableColumn col = colModel.getColumn(i);
            col.setPreferredWidth(tableFormat.getColumnWidth(i));
            ++i;
        }
        table.setSelectionModel((ListSelectionModel)this.addressSelection);
        TableComparatorChooser.install((JTable)table, this.addresses, (Object)AbstractTableComparatorChooser.SINGLE_COLUMN);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selCount = table.getSelectedRowCount();
                AddressListPanel.this.getButtonEdit().setEnabled(selCount == 1);
                AddressListPanel.this.getButtonDelete().setEnabled(selCount > 0);
            }
        });
        this.getButtonAdd().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressListPanel.this.showNotImplementedDialog();
            }
        });
        this.getButtonEdit().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressListPanel.this.showNotImplementedDialog();
            }
        });
        this.getButtonDelete().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Address address = AddressListPanel.this.getSelectedAddress();
                if (address != null) {
                    class DeleteListener
                    extends ControllerResultBusyAdapter<AddressListPanel>
                    implements AddressController.DeleteAddressListener {
                        public DeleteListener() {
                            super(AddressListPanel.this.busyComponent);
                        }

                        @Override
                        @InvokeAndWait
                        public void addressDeleted(int id) {
                            System.err.println("deleteAddress(int,long) [" + Thread.currentThread() + "]");
                            AddressListPanel.this.deleteAddress(id);
                        }
                    }
                    AddressListPanel.this.addressController.deleteAddress(address, new DeleteListener());
                }
            }
        });
        this.getButtonRefresh().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Address address = AddressListPanel.this.getSelectedAddress();
                int id = address == null ? -1 : address.getId();
                class LoadListener
                extends ControllerResultBusyAdapter<AddressListPanel>
                implements AddressController.LoadAddressesListener {
                    public LoadListener() {
                        super(AddressListPanel.this.busyComponent);
                    }

                    @Override
                    @InvokeAndWait
                    public void setAddresses(List<Address> list) {
                        System.err.println("setAdresses(List<Address>) [" + Thread.currentThread() + "]");
                        AddressListPanel.this.setAdresses(list);
                    }

                    @Override
                    @InvokeAndWait
                    public void selectAddress(int id) {
                        System.err.println("selectAddress(int) [" + Thread.currentThread() + "]");
                        AddressListPanel.this.selectAdress(id);
                    }
                }
                AddressListPanel.this.addressController.loadAddresses(id, new LoadListener());
            }
        });
    }

    public JComponent getView() {
        return this.busyComponent;
    }

    private JButton getButtonAdd() {
        return (JButton)this.getButton("ButtonAdd");
    }

    private JButton getButtonEdit() {
        return (JButton)this.getButton("ButtonEdit");
    }

    private JButton getButtonDelete() {
        return (JButton)this.getButton("ButtonDelete");
    }

    private JButton getButtonRefresh() {
        return (JButton)this.getButton("ButtonRefresh");
    }

    private JTable getTableAddresses() {
        return this.getTable("TableAddresses");
    }

    public final void setAddressController(AddressController addressListController) {
        this.addressController = addressListController;
    }

    private Address getSelectedAddress() {
        List selectedAddresses = (List)this.addressSelection.getSelected();
        if (selectedAddresses.size() == 0) {
            return null;
        }
        return (Address)selectedAddresses.get(0);
    }

    private void setAdresses(List<Address> list) {
        this.addresses.clear();
        this.addresses.addAll(list);
    }

    private int indexOf(int id) {
        if (id < 0) {
            return -1;
        }
        int i = 0;
        while (i < this.addresses.size()) {
            Address address = (Address)this.addresses.get(i);
            if (address.getId() == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void selectAdress(int id) {
        if (id > 0) {
            return;
        }
        int i = this.indexOf(id);
        if (i > -1) {
            this.getTableAddresses().getSelectionModel().setSelectionInterval(i, i);
        }
    }

    private void deleteAddress(int id) {
        int idx = this.indexOf(id);
        if (idx > -1) {
            this.addresses.remove(idx);
            if (this.addresses.size() == 0) {
                this.repaint();
            } else {
                int row = idx;
                if (row >= this.addresses.size()) {
                    row = this.addresses.size() - 1;
                }
                this.getTableAddresses().getSelectionModel().setSelectionInterval(row, row);
            }
        }
    }

    private void showNotImplementedDialog() {
        JOptionPane.showMessageDialog((Component)((Object)this), "Sorry, not implemented yet!\n\n Only 'Refresh' and 'Delete' are available!\n\n", "Message", 1);
    }
}

