/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.jmsmvc4swing;

import java.util.ArrayList;
import java.util.List;
import org.fuin.examples.jmsmvc4swing.Address;
import org.fuin.examples.jmsmvc4swing.AddressController;
import org.fuin.jmsmvc4swing.base.ProgressInfo;

public final class AddressControllerImpl
implements AddressController {
    private final List<Address> addresses = new ArrayList<Address>();

    @Override
    public final void loadAddresses(int selectedId, AddressController.LoadAddressesListener listener) {
        listener.progress(new ProgressInfo("Started loading", 0, 0, 0, 4));
        this.addresses.clear();
        this.sleep(1000);
        Address adr1 = new Address();
        adr1.setId(1).setLastName("Parker").setFirstName("Peter").setStreet("70 Park Ave").setZip("10016").setCity("New York").setCountry("US");
        this.addresses.add(adr1);
        listener.progress(new ProgressInfo("Loaded '" + adr1.getFirstName() + " " + adr1.getLastName() + "'", 0, 1, 0, 4));
        this.sleep(1000);
        Address adr2 = new Address();
        adr2.setId(2).setLastName("Watson").setFirstName("Mary Jane").setStreet("70 Park Ave").setZip("10016").setCity("New York").setCountry("US");
        this.addresses.add(adr2);
        listener.progress(new ProgressInfo("Loaded '" + adr2.getFirstName() + " " + adr1.getLastName() + "'", 0, 2, 0, 4));
        this.sleep(1000);
        Address adr3 = new Address();
        adr3.setId(3).setLastName("Osborn").setFirstName("Harry").setStreet("2nd Ave 44th Street").setZip("10017").setCity("New York").setCountry("US");
        this.addresses.add(adr3);
        listener.progress(new ProgressInfo("Loaded '" + adr3.getFirstName() + " " + adr1.getLastName() + "'", 0, 3, 0, 4));
        this.sleep(1000);
        listener.setAddresses(this.addresses);
        if (selectedId > -1) {
            listener.selectAddress(selectedId);
        }
        listener.progress(new ProgressInfo("Finished loading", 0, 4, 0, 4));
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void deleteAddress(Address address, AddressController.DeleteAddressListener listener) {
        this.addresses.remove(address);
        this.sleep(2000);
        listener.addressDeleted(address.getId());
    }
}

