/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.apps4xxxxx;

import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import org.fuin.apps4j.base.CanceledException;
import org.fuin.apps4j.base.ModuleImplIntf;
import org.fuin.apps4j.base.Usage;
import org.fuin.apps4j.base.WindowManager;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginModuleImplIntf;
import org.fuin.examples.apps4xxxxx.LoginView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;

@Named(value="loginController")
@Usage(value=Usage.Type.Intern)
@Lazy
public class LoginControllerImpl
implements LoginController,
LoginModuleImplIntf {
    private static final String TITLE = "Login Example Dialog";
    private static final Logger LOG = LoggerFactory.getLogger(LoginControllerImpl.class);
    @Inject
    @Usage(value=Usage.Type.Controller)
    private LoginView view;
    private LoginModuleImplIntf.LoginListener listener;
    @Inject
    private WindowManager windowManager;

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean isPasswordCorrect(char[] input) {
        boolean isCorrect = true;
        char[] correctPassword = new char[]{'t', 'e', 's', 't'};
        isCorrect = input.length != correctPassword.length ? false : Arrays.equals(input, correctPassword);
        Arrays.fill(correctPassword, '0');
        if (!isCorrect) {
            this.sleep(2000L);
        }
        return isCorrect;
    }

    public final void setView(LoginView view) {
        this.view = view;
    }

    @Override
    public final void cancel() {
        LOG.info("cancel");
        this.windowManager.close((ModuleImplIntf)this);
        if (this.listener != null) {
            this.listener.failure(new CanceledException());
            this.listener = null;
        }
    }

    @Override
    public final void verify(String username, char[] password) {
        LOG.info("verify '" + username + "'");
        if (this.isPasswordCorrect(password)) {
            LOG.info("LOGIN OK!");
            this.windowManager.close((ModuleImplIntf)this);
            this.listener.success(username);
            this.listener = null;
        } else {
            String message = "INVALID USERNAME OR PASSWORD";
            LOG.info("INVALID USERNAME OR PASSWORD");
            this.view.setMessage("INVALID USERNAME OR PASSWORD");
        }
    }

    @Override
    public final void login(LoginModuleImplIntf.LoginListener listener, String username) {
        LOG.info("login '" + username + "'");
        this.windowManager.open((ModuleImplIntf)this, TITLE);
        this.view.setUsername(username);
        this.view.setMessage("");
        this.listener = listener;
    }

    @Override
    public final void login(LoginModuleImplIntf.LoginListener listener) {
        LOG.info("login");
        this.windowManager.open((ModuleImplIntf)this, TITLE);
        this.view.setUsername("");
        this.view.setMessage("");
        this.listener = listener;
    }

    public final Object getModuleUI() {
        return this.view.getViewUI();
    }

    public final void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public final Object getControllerUI() {
        return this.view.getViewUI();
    }

    public final String getName() {
        return "Login";
    }
}

