/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.apps4swing;

import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.divxdede.swing.busy.JBusyComponent;
import org.fuin.apps4j.base.Usage;
import org.fuin.apps4swing.DefaultButtonCapable;
import org.fuin.examples.apps4swing.AbstractLoginPanel;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;

@Named(value="loginView")
@Usage(value=Usage.Type.Intern)
@Lazy
public class LoginPanel
extends AbstractLoginPanel
implements LoginView,
DefaultButtonCapable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLoginPanel.class);
    @Inject
    @Usage(value=Usage.Type.View)
    private LoginController ctrl;
    private JBusyComponent<LoginPanel> busyComponent = new JBusyComponent((JComponent)this);

    public Object getViewUI() {
        return this.busyComponent;
    }

    public LoginController getController() {
        return this.ctrl;
    }

    public void setController(LoginController ctrl) {
        this.ctrl = ctrl;
    }

    public void block() {
        this.busyComponent.setBusy(true);
    }

    public void unblock() {
        this.busyComponent.setBusy(false);
    }

    public JButton getDefaultButton() {
        return this.getButtonOK();
    }

    @Override
    public void setUsername(String username) {
        LOG.info("SET USERNAME '" + username + "'");
        this.getTextFieldUsername().setText(username);
    }

    @Override
    public void setMessage(String message) {
        LOG.info("SET MESSAGE '" + message + "'");
        this.getLabelMessage().setText(message);
    }

    @Override
    protected void cancel() {
        this.ctrl.cancel();
    }

    @Override
    protected void verify(String username, char[] password) {
        this.ctrl.verify(username, password);
    }
}

