/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.utils4swing5.appletviewer;

import javax.swing.SwingUtilities;

import org.fuin.utils4swing.appletviewer.SimpleAppletViewer;
import org.fuin.utils4swing.appletviewer.SimpleAppletViewerConfig;
import org.fuin.utils4swing.common.Utils4Swing;

/**
 * Shows how to run the Applet Viewer programmatically.
 */
public final class AppletViewerExample {

	/**
	 * Private constructor.
	 */
	private AppletViewerExample() {
		throw new UnsupportedOperationException(
				"Creating an instance is not allowed (utility class!)!");
	}

	/**
	 * Start the example.
	 * 
	 * @param args
	 *            Not used.
	 */
	public static void main(final String[] args) {

		// Create a viewer instance
		final SimpleAppletViewerConfig appletViewerConfig = new SimpleAppletViewerConfig();

		// Set the applet to run
		appletViewerConfig.setApplet(new HelloWorldApplet());

		// Add arguments (optional)
		appletViewerConfig.addArgument("useless", "1");
		appletViewerConfig.addArgument("dummy", "2");
		appletViewerConfig.addArgument("arguments", "3");

		// Start the viewer in EDT thread
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				Utils4Swing.initSystemLookAndFeel();
				(new SimpleAppletViewer(appletViewerConfig)).execute();
			}
		});

	}

}
