/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.srcgen4javassist.factory;

/**
 * Example controller interface.
 */
public interface IController {

	/**
	 * Starts the controller.
	 * 
	 * @return If the controller was started successfully <code>true</code> else
	 *         <code>false</code>.
	 */
	public boolean start();

	/**
	 * Update a message.
	 * 
	 * @param id
	 *            ID of the message.
	 * @param message
	 *            Text.
	 * 
	 * @throws UpdateException
	 *             The update was not successful.
	 */
	public void update(int id, String message) throws UpdateException;

	/**
	 * Stops the controller.
	 */
	public void stop();

}
