/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.srcgen4javassist.factory;

import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.factory.ImplementationFactory;

/**
 * Example for implementing an interface using an {@link ImplementationFactory}.
 */
public final class ExampleImplementationFactoryExample {

	/**
	 * Private constructor.
	 */
	private ExampleImplementationFactoryExample() {
		throw new UnsupportedOperationException("Cannot create an instance!");
	}

	/**
	 * Starts the example.
	 * 
	 * @param args
	 *            Not used.
	 */
	public static void main(final String[] args) {

		// Generator that finally creates the real class
		final ByteCodeGenerator generator = new ByteCodeGenerator();

		// Cache for the class definitions
		final SgClassPool pool = new SgClassPool();

		// Creates the body of the methods
		final ExampleImplementionFactoryListener listener = new ExampleImplementionFactoryListener();

		// Creates the implementation class without method bodies and calls the
		// listener
		final ImplementationFactory factory = new ImplementationFactory(pool);
		final SgClass clasz = factory.create("org.fuin.srcgen4javassist.examples",
				"ControllerImpl", listener, IController.class);

		// Create the class and a new instance
		final IController controller = (IController) generator.createInstance(clasz);

		// Try the new generated code
		System.out.println("BEGIN");

		controller.start();
		try {
			controller.update(1, "Hello, world!");
		} catch (final UpdateException ex) {
			System.out.println("Caught exception: " + ex.getMessage());
		}
		controller.stop();

		System.out.println("END");

	}

}
