/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.jmsmvc4swing;

import java.util.ArrayList;
import java.util.List;

import org.fuin.jmsmvc4swing.base.ProgressInfo;

/**
 * Implementation of the controller that does the actual work.
 */
public final class AddressControllerImpl implements AddressController {

    private final List<Address> addresses = new ArrayList<Address>();    
    
    /**
     * Default constructor.
     */
    public AddressControllerImpl() {
        super();
    }

    /**
     * {@inheritDoc}
     */
    public final void loadAddresses(final int selectedId, final LoadAddressesListener listener) {

        listener.progress(new ProgressInfo("Started loading", 0, 0, 0, 4));
        addresses.clear();
        sleep(1000);

        final Address adr1 = new Address();
        adr1.setId(1).setLastName("Parker").setFirstName("Peter").setStreet("70 Park Ave")
                .setZip("10016").setCity("New York").setCountry("US");
        addresses.add(adr1);

        listener.progress(new ProgressInfo("Loaded '" + adr1.getFirstName() + " "
                + adr1.getLastName() + "'", 0, 1, 0, 4));
        sleep(1000);

        final Address adr2 = new Address();
        adr2.setId(2).setLastName("Watson").setFirstName("Mary Jane").setStreet("70 Park Ave")
                .setZip("10016").setCity("New York").setCountry("US");
        addresses.add(adr2);

        listener.progress(new ProgressInfo("Loaded '" + adr2.getFirstName() + " "
                + adr1.getLastName() + "'", 0, 2, 0, 4));
        sleep(1000);

        final Address adr3 = new Address();
        adr3.setId(3).setLastName("Osborn").setFirstName("Harry").setStreet(
                "2nd Ave 44th Street").setZip("10017").setCity("New York").setCountry("US");
        addresses.add(adr3);

        listener.progress(new ProgressInfo("Loaded '" + adr3.getFirstName() + " "
                + adr1.getLastName() + "'", 0, 3, 0, 4));
        sleep(1000);

        listener.setAddresses(addresses);

        if (selectedId > -1) {
            listener.selectAddress(selectedId);
        }

        listener.progress(new ProgressInfo("Finished loading", 0, 4, 0, 4));
    }

    private void sleep(final int ms) {
        // Simulate slow controller
        try {
            Thread.sleep(ms);
        } catch (final InterruptedException e) {
            // Ignore
        	e.printStackTrace();
        }
    }

    /**
     * {@inheritDoc}
     */
    public final void deleteAddress(final Address address, final DeleteAddressListener listener) {
        addresses.remove(address);
        sleep(2000);
        listener.addressDeleted(address.getId());
    }

}
