/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.aspects4swing;

import java.io.File;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Helper class to demonstrate tracing.
 */
public final class LargestFileFinder {

    private static final Logger LOG = LoggerFactory.getLogger(LargestFileFinder.class);

    /**
     * Find the largest file in a directory or it's sub directories.
     * 
     * @param dir
     *            Directory.
     * 
     * @return Largest file found or <code>null</code> if no file was found.
     */
    public final File findLargestFile(final File dir) {
        long max = 0;
        File largest = null;
        final File[] files = dir.listFiles();
        for (int i = 0; i < files.length; i++) {
            if (files[i].isDirectory()) {
                final File file = findLargestFile(files[i]);
                if ((file != null) && (file.length() > max)) {
                    max = file.length();
                    largest = file;
                }
            } else {
                if (files[i].length() > max) {
                    max = files[i].length();
                    largest = files[i];
                }
            }
        }
        LOG.trace("max " + max + ": " + dir);
        return largest;
    }

}
