/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.apps4swing;

import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.JButton;

import org.divxdede.swing.busy.JBusyComponent;
import org.fuin.apps4j.base.Usage;
import org.fuin.apps4j.base.Usage.Type;
import org.fuin.apps4swing.DefaultButtonCapable;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;

/**
 * Example login panel.
 */
@Named("loginView")
@Usage(Usage.Type.Intern)
@Lazy
public class LoginPanel extends AbstractLoginPanel implements LoginView, DefaultButtonCapable {

    private static final long serialVersionUID = 1L;

    private static final Logger LOG = LoggerFactory.getLogger(AbstractLoginPanel.class);

    @Inject
    @Usage(Type.View)
    private LoginController ctrl;

    private JBusyComponent<LoginPanel> busyComponent;

    /**
     * Default constructor.
     */
    public LoginPanel() {
        super();
        busyComponent = new JBusyComponent<LoginPanel>(this);
    }

    public Object getViewUI() {
        return busyComponent;
    }

    public LoginController getController() {
        return ctrl;
    }

    public void setController(LoginController ctrl) {
        this.ctrl = ctrl;
    }

    public void block() {
        busyComponent.setBusy(true);
    }

    public void unblock() {
        busyComponent.setBusy(false);
    }

    /**
     * Returns the default button.
     * 
     * @return Default button.
     */
    public JButton getDefaultButton() {
        return getButtonOK();
    }

    /**
     * {@inheritDoc}
     */
    public void setUsername(String username) {
        LOG.info("SET USERNAME '" + username + "'");
        getTextFieldUsername().setText(username);
    }

    /**
     * {@inheritDoc}
     */
    public void setMessage(String message) {
        LOG.info("SET MESSAGE '" + message + "'");
        getLabelMessage().setText(message);
    }

    @Override
    protected void cancel() {
        ctrl.cancel();
    }

    @Override
    protected void verify(String username, char[] password) {
        ctrl.verify(username, password);
    }

}
