/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.apps4swing;

import java.util.Properties;

import org.apache.log4j.PropertyConfigurator;
import org.fuin.apps4j.base.CanceledException;
import org.fuin.apps4swing.SpringMvcContext;
import org.fuin.examples.apps4xxxxx.LoginModule;
import org.fuin.utils4swing.common.Utils4Swing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * Better approach using an easy framework to connect controller and view.
 */
public final class LoginDialogBetterApproachWithSpring {

    private static final Logger LOG = LoggerFactory
            .getLogger(LoginDialogBetterApproachWithSpring.class);

    /**
     * Start the application in calling (main) thread.
     */
    public final void start() {

        LOG.info("start()");

        try {
            // Initialize Look and Feel
            Utils4Swing.initSystemLookAndFeel();

            // Get Spring context and initialize MVC
            final ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(
                    "application-context-login-example.xml");
            ctx.getBean(SpringMvcContext.class).init(); // IMPORTANT!

            // Start the module in the main thread
            final LoginModule module = ctx.getBean(LoginModule.class);
            try {
                final String username = module.login("john");
                LOG.info("Login successful: " + username);
            } catch (final CanceledException ex) {
                LOG.info(ex.getMessage());
                LOG.info("exit(1)");
                System.exit(1);
            }

            // Finished
            LOG.info("exit(0)");
            System.exit(0);

        } catch (final Throwable t) {
            LOG.error("exit(2)", t);
            System.exit(2);
        }

    }

    private static void configureLog4J() {
        final Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, A1");
        props.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.A1.layout.ConversionPattern",
                "%d{HH:mm:ss,SSS} [%-20t] %-5p %-40c{1} - %m%n");
        PropertyConfigurator.configure(props);
    }

    /**
     * Starts the example.
     * 
     * @param args
     *            Not used.
     */
    public static void main(final String[] args) {
        configureLog4J();
        new LoginDialogBetterApproachWithSpring().start();
    }

}
