/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.srcgen4javassist;

import org.fuin.examples.srcgen4javassist.MyIntf;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgBehavior;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;

public final class GenerateExample {
    private GenerateExample() {
        throw new UnsupportedOperationException("It's not allowed to create an instance of this class!");
    }

    public static SgClass create(SgClassPool pool, String packageName) {
        SgClass clasz = new SgClass(packageName, "MyImpl");
        clasz.addInterface(SgClass.create((SgClassPool)pool, MyIntf.class));
        new SgField(clasz, "public", SgClass.create((SgClassPool)pool, String.class), "name", "\"unknown\"");
        SgMethod getNameMethod = new SgMethod(clasz, "public", SgClass.create((SgClassPool)pool, String.class), "getName");
        getNameMethod.addBodyLine("return name;");
        SgMethod setNameMethod = new SgMethod(clasz, "public", SgClass.VOID, "setName");
        new SgArgument((SgBehavior)setNameMethod, SgClass.create((SgClassPool)pool, String.class), "name");
        setNameMethod.addBodyLine("this.name = name;");
        SgMethod sayHelloMethod = new SgMethod(clasz, "public", SgClass.VOID, "sayHello");
        sayHelloMethod.addBodyLine("System.out.println(\"Hello \" + name + \"!\");");
        return clasz;
    }

    public static void main(String[] args) {
        SgClassPool pool = new SgClassPool();
        SgClass clasz = GenerateExample.create(pool, "test");
        System.out.println(clasz);
        System.out.println("-----------");
        MyIntf example = (MyIntf)new ByteCodeGenerator().createInstance(clasz);
        example.setName("John");
        example.sayHello();
    }
}

