/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.apps4xxxxx;

import java.util.Arrays;
import org.fuin.apps4j.CanceledException;
import org.fuin.apps4j.WindowManager;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginModuleImplIntf;
import org.fuin.examples.apps4xxxxx.LoginView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginControllerImpl
implements LoginController,
LoginModuleImplIntf {
    private static final Logger LOG = LoggerFactory.getLogger(LoginControllerImpl.class);
    private LoginView view;
    private LoginModuleImplIntf.LoginListener listener;
    private WindowManager windowManager;

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean isPasswordCorrect(char[] input) {
        this.sleep(5000L);
        boolean isCorrect = true;
        char[] correctPassword = new char[]{'t', 'e', 's', 't'};
        isCorrect = input.length != correctPassword.length ? false : Arrays.equals(input, correctPassword);
        Arrays.fill(correctPassword, '0');
        return isCorrect;
    }

    public final void setView(LoginView view) {
        this.view = view;
    }

    public final void cancel() {
        LOG.info("cancel");
        this.windowManager.close();
        if (this.listener != null) {
            this.listener.failure(new CanceledException());
            this.listener = null;
        }
    }

    public final void verify(String username, char[] password) {
        LOG.info("verify '" + username + "'");
        if (this.isPasswordCorrect(password)) {
            LOG.info("LOGIN OK!");
            this.windowManager.close();
            this.listener.success(username);
            this.listener = null;
        } else {
            LOG.info("INVALID USERNAME OR PASSWORD");
            this.view.setMessage("INVALID USERNAME OR PASSWORD");
        }
    }

    public final void login(LoginModuleImplIntf.LoginListener listener, String username) {
        LOG.info("login '" + username + "'");
        this.windowManager.open();
        this.view.setUsername(username);
        this.view.setMessage("");
        this.listener = listener;
    }

    public final void login(LoginModuleImplIntf.LoginListener listener) {
        LOG.info("login");
        this.windowManager.open();
        this.view.setUsername("");
        this.view.setMessage("");
        this.listener = listener;
    }

    public final String getModuleTitle() {
        return "Login Example Dialog";
    }

    public final Object getModuleUI() {
        return this.view.getViewUI();
    }

    public final void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }
}

