/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.utils4swing5.appstarter;

import org.fuin.utils4swing.appstarter.AppStarterConfig;
import org.fuin.utils4swing.appstarter.ClasspathBinDirEntry;
import org.fuin.utils4swing.appstarter.ClasspathJarsDirEntry;
import org.fuin.utils4swing.appstarter.StartType;

/**
 * Utilities for the example package.
 */
public final class Utils {

	/** Path where Sun's password store example is located. */
	private static final String PASSWORD_STORE_EXAMPLE_PATH = "C:/PasswordStoreExample";

	/**
	 * Private constructor.
	 */
	private Utils() {
		throw new UnsupportedOperationException(
				"Creating an instance is not allowed (utility class!)!");
	}

	/**
	 * Create a pre-populated configuration for the Sun "password store" swing
	 * example.
	 * 
	 * @return New config instance.
	 */
	public static AppStarterConfig createExampleConfig() {

		// Create a configuration and set title for the "AppStarter" frame
		final AppStarterConfig config = new AppStarterConfig();
		config.setFrameTitle("MyAppStarter");

		// We want to start a standalone Java application
		config.setStartType(StartType.APPLICATION);

		// Add a single jar, a directory with libraries and a binary directory
		// to the classpath
		config.addClasspathEntry(new ClasspathJarsDirEntry(
				PASSWORD_STORE_EXAMPLE_PATH + "/lib"));
		config.addClasspathEntry(new ClasspathBinDirEntry(
				PASSWORD_STORE_EXAMPLE_PATH + "/bin"));

		// Set the name of the main class
		config.setMainClass("passwordstore.ui.PasswordStoreApplication");

		// Add some (in case of the "PasswordStoreApplication" never used)
		// command line arguments
		config.addArgument("useless");
		config.addArgument("dummy");
		config.addArgument("arguments");

		return config;
	}

}
