/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.srcgen4javassist.factory;

import java.util.ArrayList;
import java.util.List;

import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;

/**
 * Creates the source for the {@link IController} interface.
 */
public final class ExampleImplementionFactoryListener implements ImplementationFactoryListener {

    /**
     * {@inheritDoc}
     */
    public final void afterClassCreated(final SgClass clasz) {
        // Nothing to do
    }

    /**
     * {@inheritDoc}
     */
    public final List<String> createBody(final SgMethod method, final Class<?>... intf) {
        final List<String> lines = new ArrayList<String>();
        lines.add("System.out.println(\"CALL " + method.getSignature() + "\");");
        // Return a dummy value
        if (!method.getReturnType().equals(SgClass.VOID)) {
            final String value;
            if (method.getReturnType().equals(SgClass.BOOLEAN)) {
                value = "false";
            } else if (method.getReturnType().equals(SgClass.BYTE)) {
                value = "(byte)0";
            } else if (method.getReturnType().equals(SgClass.CHAR)) {
                value = "' '";
            } else if (method.getReturnType().equals(SgClass.SHORT)) {
                value = "(short)0";
            } else if (method.getReturnType().equals(SgClass.INT)) {
                value = "0";
            } else if (method.getReturnType().equals(SgClass.LONG)) {
                value = "0";
            } else if (method.getReturnType().equals(SgClass.FLOAT)) {
                value = "(float)0";
            } else if (method.getReturnType().equals(SgClass.DOUBLE)) {
                value = "(double)0";
            } else {
                value = "null";
            }
            lines.add("return " + value + ";");
        }
        return lines;

    }

}
