/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.apps4xxxxx;

import org.fuin.apps4j.View;

/**
 * Login view used by the controller.
 */
public interface LoginView extends View<LoginController> {

	/**
	 * Sets the username in the view. 
	 * 
	 * @param username Username to set.
	 */
	public void setUsername(String username);
	
	/**
	 * Sets a message in the view.
	 * 
	 * @param message Message to set.
	 */
	public void setMessage(String message);
	
}
