/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.apps4swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import org.apache.log4j.PropertyConfigurator;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginControllerImpl;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;

/**
 * Naive approach to connect controller and view.
 */
public final class LoginDialogNaiveApproach {

	/**
	 * Runs in the Event Dispatch Thread (EDT).
	 */
	private void startIntern() {

		// Initialize Look and Feel
		Utils4Swing.initSystemLookAndFeel();

		// Create view (=panel) and show it in a frame
		final LoginPanel view = new LoginPanel();
		final JFrame frame = Utils4Swing.createShowAndPosition("Password Example Dialog", view,
				false, new ScreenCenterPositioner());
		frame.getRootPane().setDefaultButton(view.getDefaultButton());

		// Create controller
		final LoginController ctrl = new LoginControllerImpl();

		// Connect controller and view
		ctrl.setView(view);
		view.setController(ctrl);

		// Call cancel on Window closing
        frame.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(final WindowEvent e) {
                ctrl.cancel();
            }
        });
		
	}

	/**
	 * Start the application in EDT thread.
	 */
	public final void start() {
		if (SwingUtilities.isEventDispatchThread()) {
			startIntern();
		} else {
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					startIntern();
				}
			});
		}
	}

	private static void configureLog4J() {
		final Properties props = new Properties();
		props.put("log4j.rootLogger", "INFO, A1");
		props.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
		props.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
		props.put("log4j.appender.A1.layout.ConversionPattern",
				"%d{HH:mm:ss,SSS} [%-20t] %-5p %-40c{1} - %m%n");
		PropertyConfigurator.configure(props);
	}

	/**
	 * Starts the example.
	 * 
	 * @param args
	 *            Not used.
	 */
	public static void main(final String[] args) {
		configureLog4J();
		new LoginDialogNaiveApproach().start();
	}

}
