package org.fuin.examples.apps4pivot;

import java.io.IOException;

import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtkx.WTKXSerializer;
import org.fuin.examples.apps4swing.LoginPanel;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Implements the login view using the Apache Pivot framework.
 */
public final class LoginViewImpl implements LoginView {

    private static final Logger LOG = LoggerFactory.getLogger(LoginPanel.class);

    private LoginController ctrl;

    private final Window window;

    private final TextInput textFieldUsername;

    private final TextInput textFieldPassword;
    
    private final PushButton buttonOk;
    
    private final PushButton buttonCancel;
    
    private final Label labelMessage;
    
    /**
     * Default constructor.
     */
    public LoginViewImpl() {
        super();
        
        final WTKXSerializer wtkxSerializer = new WTKXSerializer();
        try {
            
            window = (Window) wtkxSerializer.readObject(this, "login-view.wtkx");
            textFieldUsername = (TextInput) wtkxSerializer.get("textFieldUsername");
            textFieldPassword = (TextInput) wtkxSerializer.get("textFieldPassword");            
            buttonOk = (PushButton) wtkxSerializer.get("buttonOk");
            buttonCancel = (PushButton) wtkxSerializer.get("buttonCancel");
            labelMessage = (Label) wtkxSerializer.get("labelMessage");
            
            buttonOk.getButtonPressListeners().add(new ButtonPressListener() {
                public void buttonPressed(final Button button) {
                    ctrl.verify(textFieldUsername.getText(), textFieldPassword
                            .getText().toCharArray());
                }
            });
            
            buttonCancel.getButtonPressListeners().add(new ButtonPressListener() {
                public void buttonPressed(final Button button) {
                    ctrl.cancel();
                }
            });

        } catch (final SerializationException ex) {
            throw new RuntimeException(ex);
        } catch (final IOException ex) {
            throw new RuntimeException(ex);
        }
        
    }

    /**
     * {@inheritDoc}
     */
    public final void setMessage(final String message) {
        LOG.info("SET MESSAGE '" + message + "'");
        labelMessage.setText(message);
    }

    /**
     * {@inheritDoc}
     */
    public final void setUsername(final String username) {
        LOG.info("SET USERNAME '" + username + "'");
        textFieldUsername.setText(username);
    }

    /**
     * {@inheritDoc}
     */
    public final void block() {
        window.setEnabled(false);
    }

    /**
     * {@inheritDoc}
     */
    public final void unblock() {
        window.setEnabled(true);
    }

    /**
     * {@inheritDoc}
     */
    public final Window getViewUI() {
        return window;
    }

    /**
     * {@inheritDoc}
     */
    public final LoginController getController() {
        return ctrl;
    }

    /**
     * {@inheritDoc}
     */
    public final void setController(final LoginController ctrl) {
        this.ctrl = ctrl;
    }

}
