/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.apps4pivot;

import java.util.Properties;

import org.apache.log4j.PropertyConfigurator;
import org.apache.pivot.collections.Map;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.DesktopApplicationContext;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Window;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginControllerImpl;
import org.fuin.examples.apps4xxxxx.LoginView;

/**
 * Naive approach to connect controller and view.
 */
public final class LoginDialogNaiveApproach implements Application {

    private final Window window;

    public LoginDialogNaiveApproach() {
        super();

        // Create view
        final LoginView view = new LoginViewImpl();
        window = (Window) view.getViewUI();

        // Create controller
        final LoginController ctrl = new LoginControllerImpl();

        // Connect controller and view
        ctrl.setView(view);
        view.setController(ctrl);

        // Call cancel on Window closing
        // TODO Implement!
    }

    /**
     * {@inheritDoc}
     */
    public void startup(final Display display, final Map<String, String> properties)
            throws Exception {
        // Make view visible
        window.open(display);
    }

    /**
     * {@inheritDoc}
     */
    public final boolean shutdown(final boolean optional) {
        if (window != null) {
            window.close();
        }
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public final void suspend() {
        // Do nothing
    }

    /**
     * {@inheritDoc}
     */
    public final void resume() {
        // Do nothing
    }

    private static void configureLog4J() {
        final Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, A1");
        props.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.A1.layout.ConversionPattern",
                "%d{HH:mm:ss,SSS} [%-20t] %-5p %-40c{1} - %m%n");
        PropertyConfigurator.configure(props);
    }

    /**
     * Starts the example.
     * 
     * @param args
     *            Not used.
     */
    public static void main(final String[] args) {
        configureLog4J();
        DesktopApplicationContext.main(LoginDialogNaiveApproach.class, args);
    }

}
