/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.utils4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.fuin.utils4j.Utils4J;

public final class ZipDirExample {
    private ZipDirExample() {
        throw new UnsupportedOperationException("It's not allowed to create an instance of this class!");
    }

    private static void copyResourceToFile(String resource, File target) throws IOException {
        InputStream in = ZipDirExample.class.getResourceAsStream(resource);
        try {
            FileOutputStream out = new FileOutputStream(target);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            in.close();
        }
    }

    public static void main(String[] args) throws IOException {
        File zipFile = File.createTempFile("ZipDirExample", ".zip");
        try {
            ZipDirExample.copyResourceToFile("/myfile.zip", zipFile);
            File zipDir = new File("c:/mydir");
            zipDir.mkdir();
            Utils4J.unzip((File)zipFile, (File)zipDir);
        }
        finally {
            zipFile.delete();
        }
        File dirToZip = new File("c:/mydir");
        Utils4J.zipDir((File)dirToZip, (String)"abc/def", (File)new File("c:/myfile1.zip"));
        Utils4J.zipDir((File)dirToZip, (String)"", (File)new File("c:/myfile2.zip"));
    }
}

