/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.apps4swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginPanel
extends JPanel
implements LoginView {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LoginPanel.class);
    private LoginController ctrl;
    private JLabel labelUsername;
    private JLabel labelPassword;
    private JTextField textFieldUsername;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JPasswordField textFieldPassword;
    private JLabel labelLogIn;
    private JLabel labelMessage;

    public LoginPanel() {
        this.initComponents();
        this.initHandler();
    }

    public JPanel getViewUI() {
        return this;
    }

    public LoginController getController() {
        return this.ctrl;
    }

    public void setController(LoginController ctrl) {
        this.ctrl = ctrl;
    }

    public void block() {
    }

    public void unblock() {
    }

    public JButton getDefaultButton() {
        return this.buttonOK;
    }

    public void setUsername(String username) {
        LOG.info("SET USERNAME '" + username + "'");
        this.textFieldUsername.setText(username);
    }

    public void setMessage(String message) {
        LOG.info("SET MESSAGE '" + message + "'");
        this.labelMessage.setText(message);
    }

    private void initHandler() {
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.ctrl.verify(LoginPanel.this.textFieldUsername.getText(), LoginPanel.this.textFieldPassword.getPassword());
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.ctrl.cancel();
            }
        });
        this.setPreferredSize(new Dimension(300, 200));
    }

    private void initComponents() {
        this.labelUsername = new JLabel();
        this.labelPassword = new JLabel();
        this.textFieldUsername = new JTextField();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.textFieldPassword = new JPasswordField();
        this.labelLogIn = new JLabel();
        this.labelMessage = new JLabel();
        this.setPreferredSize(new Dimension(400, 300));
        this.setName("this");
        this.setLayout(null);
        this.labelUsername.setText("Username:");
        this.labelUsername.setName("labelUsername");
        this.add(this.labelUsername);
        this.labelUsername.setBounds(20, 40, 57, 19);
        this.labelPassword.setText("Password:");
        this.labelPassword.setName("labelPassword");
        this.add(this.labelPassword);
        this.labelPassword.setBounds(20, 65, 59, 19);
        this.textFieldUsername.setName("textFieldUsername");
        this.add(this.textFieldUsername);
        this.textFieldUsername.setBounds(85, 40, 160, this.textFieldUsername.getPreferredSize().height);
        this.buttonOK.setText("OK");
        this.buttonOK.setName("buttonOK");
        this.add(this.buttonOK);
        this.buttonOK.setBounds(170, 115, 75, this.buttonOK.getPreferredSize().height);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.setName("buttonCancel");
        this.add(this.buttonCancel);
        this.buttonCancel.setBounds(90, 115, 75, 25);
        this.textFieldPassword.setName("textFieldPassword");
        this.add(this.textFieldPassword);
        this.textFieldPassword.setBounds(85, 65, 160, this.textFieldPassword.getPreferredSize().height);
        this.labelLogIn.setText("Log In");
        this.labelLogIn.setFont(this.labelLogIn.getFont().deriveFont(this.labelLogIn.getFont().getStyle() | 1, (float)this.labelLogIn.getFont().getSize() + 5.0f));
        this.labelLogIn.setName("labelLogIn");
        this.add(this.labelLogIn);
        this.labelLogIn.setBounds(20, 5, 230, 20);
        this.labelMessage.setForeground(Color.red);
        this.labelMessage.setHorizontalAlignment(4);
        this.labelMessage.setText("error message");
        this.labelMessage.setName("labelMessage");
        this.add(this.labelMessage);
        this.labelMessage.setBounds(20, 90, 225, 20);
        Dimension preferredSize = new Dimension();
        int i = 0;
        while (i < this.getComponentCount()) {
            Rectangle bounds = this.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
            ++i;
        }
        Insets insets = this.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.setMinimumSize(preferredSize);
        this.setPreferredSize(preferredSize);
    }
}

