/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.apps4swing;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.PropertyConfigurator;
import org.fuin.apps4j.CanceledException;
import org.fuin.apps4j.Controller;
import org.fuin.apps4j.View;
import org.fuin.apps4swing.ModuleControllerViewConnector;
import org.fuin.examples.apps4swing.LoginPanel;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginControllerImpl;
import org.fuin.examples.apps4xxxxx.LoginModule;
import org.fuin.examples.apps4xxxxx.LoginView;
import org.fuin.utils4swing.common.Utils4Swing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginDialogBetterApproach {
    private static final Logger LOG = LoggerFactory.getLogger(LoginDialogBetterApproach.class);

    private static ExecutorService createExecutorService() {
        final ExecutorService executorService = Executors.newCachedThreadPool();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                executorService.shutdown();
            }
        });
        return executorService;
    }

    public final void start() {
        LOG.info("start()");
        try {
            Utils4Swing.initSystemLookAndFeel();
            LoginPanel view = new LoginPanel();
            LoginControllerImpl ctrl = new LoginControllerImpl();
            ModuleControllerViewConnector cvc = new ModuleControllerViewConnector("Login", "org.fuin.examples.apps4swing.generated", LoginController.class, (Controller)ctrl, "org.fuin.examples.apps4swing.generated", LoginView.class, (View)view, "org.fuin.examples.apps4swing.generated", LoginModule.class, LoginDialogBetterApproach.createExecutorService(), 4);
            LoginModule module = (LoginModule)cvc.getModule();
            try {
                String username = module.login("john");
                LOG.info("Login successful: " + username);
            }
            catch (CanceledException ex) {
                LOG.error(ex.getMessage());
            }
            LOG.info("exit(0)");
            System.exit(0);
        }
        catch (Throwable t) {
            LOG.error("exit(1)", t);
            System.exit(1);
        }
    }

    private static void configureLog4J() {
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, A1");
        props.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.A1.layout.ConversionPattern", "%d{HH:mm:ss,SSS} [%-20t] %-5p %-40c{1} - %m%n");
        PropertyConfigurator.configure((Properties)props);
    }

    public static void main(String[] args) {
        LoginDialogBetterApproach.configureLog4J();
        new LoginDialogBetterApproach().start();
    }
}

