/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.apps4pivot;

import java.io.IOException;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtkx.WTKXSerializer;
import org.fuin.examples.apps4swing.LoginPanel;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginViewImpl
implements LoginView {
    private static final Logger LOG = LoggerFactory.getLogger(LoginPanel.class);
    private LoginController ctrl;
    private final Window window;
    private final TextInput textFieldUsername;
    private final TextInput textFieldPassword;
    private final PushButton buttonOk;
    private final PushButton buttonCancel;
    private final Label labelMessage;

    public LoginViewImpl() {
        WTKXSerializer wtkxSerializer = new WTKXSerializer();
        try {
            this.window = (Window)wtkxSerializer.readObject((Object)this, "login-view.wtkx");
            this.textFieldUsername = (TextInput)wtkxSerializer.get("textFieldUsername");
            this.textFieldPassword = (TextInput)wtkxSerializer.get("textFieldPassword");
            this.buttonOk = (PushButton)wtkxSerializer.get("buttonOk");
            this.buttonCancel = (PushButton)wtkxSerializer.get("buttonCancel");
            this.labelMessage = (Label)wtkxSerializer.get("labelMessage");
            this.buttonOk.getButtonPressListeners().add((Object)new ButtonPressListener(){

                public void buttonPressed(Button button) {
                    LoginViewImpl.this.ctrl.verify(LoginViewImpl.this.textFieldUsername.getText(), LoginViewImpl.this.textFieldPassword.getText().toCharArray());
                }
            });
            this.buttonCancel.getButtonPressListeners().add((Object)new ButtonPressListener(){

                public void buttonPressed(Button button) {
                    LoginViewImpl.this.ctrl.cancel();
                }
            });
        }
        catch (SerializationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void setMessage(String message) {
        LOG.info("SET MESSAGE '" + message + "'");
        this.labelMessage.setText(message);
    }

    public final void setUsername(String username) {
        LOG.info("SET USERNAME '" + username + "'");
        this.textFieldUsername.setText(username);
    }

    public final void block() {
        this.window.setEnabled(false);
    }

    public final void unblock() {
        this.window.setEnabled(true);
    }

    public final Window getViewUI() {
        return this.window;
    }

    public final LoginController getController() {
        return this.ctrl;
    }

    public final void setController(LoginController ctrl) {
        this.ctrl = ctrl;
    }
}

