/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.utils4swing5.appstarter;

import javax.swing.SwingUtilities;

import org.fuin.utils4swing.appstarter.AppStarter;
import org.fuin.utils4swing.appstarter.AppStarterConfig;
import org.fuin.utils4swing.appstarter.AppStarterListener;
import org.fuin.utils4swing.common.Utils4Swing;

/**
 * Start an application with a pre-populated configuration screen. To run this
 * example you have to copy Sun's password store example to the following
 * directory: "C:\PasswordStoreExample". Another option is to change the path
 * constant in "Utils".
 */
public final class PrePopulatedConfigScreenExample {

	/**
	 * Private constructor.
	 */
	private PrePopulatedConfigScreenExample() {
		throw new UnsupportedOperationException(
				"Creating an instance is not allowed (utility class!)!");
	}

	/**
	 * Main method to start the "AppStarter" with a pre-populated configuration
	 * screen.
	 * 
	 * @param args
	 *            Command line arguments. Not used.
	 */
	public static void main(final String[] args) {

		// Create a configuration and set title for the "AppStarter" frame
		final AppStarterConfig config = Utils.createExampleConfig();

		// Create a listener to get informed when the target application
		// has finally started.
		final AppStarterListener listener = new AppStarterListener() {
			public void appStarted() {
				System.out.println("The 3rd Party application "
						+ "has just started!");
			}
		};

		// Start the configuration screen populated with above configuration
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				Utils4Swing.initSystemLookAndFeel();
				(new AppStarter(config, listener)).execute();
			}
		});

	}
}
