/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.jmsmvc4swing;

import java.util.List;

import org.fuin.jmsmvc4swing.base.Controller;
import org.fuin.jmsmvc4swing.base.ControllerResultListener;
import org.fuin.jmsmvc4swing.base.MethodCancelable;
import org.fuin.jmsmvc4swing.base.ProgressDeterminate;

/**
 * This interface defines the controller capabilities. It will be used in the
 * view and generating the communication classes "on-the-fly".
 */
public interface AddressController extends Controller {

	/**
	 * Loads a list of addresses and notifies a listener.
	 * 
	 * @param selectedId
	 *            ID of the currently selected address or -1 if no address is
	 *            selected.
	 * @param listener
	 *            Destination for the loaded list.
	 */
	@MethodCancelable
	@ProgressDeterminate
	public void loadAddresses(int selectedId, LoadAddressesListener listener);

	/**
	 * Listens to the results of the
	 * <code>loadAddresses(LoadAddressesListener)</code> method.
	 */
	public interface LoadAddressesListener extends ControllerResultListener {

		/**
		 * Sets the address list.
		 * 
		 * @param list
		 *            Address list.
		 */
		public void setAddresses(List<Address> list);

		/**
		 * Select the address with the given ID if it's in the list.
		 * 
		 * @param id
		 *            ID to be selected.
		 */
		public void selectAddress(int id);

	}

	/**
	 * Deletes an address.
	 * 
	 * @param address
	 *            Address to delete.
	 * @param listener
	 *            Gets notified about deletion result.
	 */
	public void deleteAddress(Address address, DeleteAddressListener listener);

	/**
	 * Listens to the results of the
	 * <code>deleteAddress(Address, DeleteAddressListener)</code> method.
	 */
	public interface DeleteAddressListener extends ControllerResultListener {

		/**
		 * Deletes an address from the view.
		 * 
		 * @param id
		 *            ID of address to remove.
		 */
		public void addressDeleted(int id);

	}

}
