/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.aspects4swing;

import java.io.File;
import java.util.Properties;

import org.apache.log4j.PropertyConfigurator;
import org.fuin.aspects4swing.Sl4jTrace;

/**
 * Main class to demonstrate tracing.
 */
public final class TraceAspectExample {

    /**
     * Private constructor.
     */
    private TraceAspectExample() {
        throw new UnsupportedOperationException(
                "It's not allowed to create an instance of this class!");
    }

    private static void configureLog4J() {
        final Properties props = new Properties();
        props.put("log4j.rootLogger", "TRACE, A1");
        props.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.A1.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
        PropertyConfigurator.configure(props);
        Sl4jTrace.setIndent("");
    }

    /**
     * Starts the example.
     * 
     * @param args
     *            Not used.
     */
    public static void main(final String[] args) {
        
        configureLog4J();
        
        final File dir = new File("./target/classes");
        final LargestFileFinder finder = new LargestFileFinder();
        final File file = finder.findLargestFile(dir); 
        System.out.println("LARGEST FILE: " + file + " [" + file.length() + "]");
        
    }

}
