/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.apps4xxxxx;

import org.fuin.apps4j.CanceledException;
import org.fuin.apps4j.ModuleImplIntf;
import org.fuin.apps4j.ModuleImplIntfListener;
import org.fuin.apps4j.ModuleRef;

/**
 * The interface every provider of the {@link LoginModule} implements.
 */
@ModuleRef(LoginModule.class)
public interface LoginModuleImplIntf extends ModuleImplIntf {

    /**
     * Shows a login dialog.
     * 
     * @param listener
     *            Listener.
     * @param username
     *            Initial user name or <code>null</code>.
     */
    public void login(LoginListener listener, String username);

    /**
     * Shows a login dialog.
     * 
     * @param listener
     *            Listener.
     */
    public void login(LoginListener listener);

    
    /**
     * Gets informed about the result of the login process.
     */
    public interface LoginListener extends ModuleImplIntfListener {

        /**
         * The login was successful.
         * 
         * @param username
         *            Name of the user that successfully logged in.
         */
        public void success(String username);

        /**
         * User canceled the login process.
         * 
         * @param ex
         *            Exception.
         */
        public void failure(CanceledException ex);

    }

}
