/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.apps4xxxxx;

import org.fuin.apps4j.CanceledException;
import org.fuin.apps4j.WaitForUserInput;
import org.fuin.apps4j.ModulImplIntfRef;
import org.fuin.apps4j.Module;

/**
 * A login dialog. Caution: Don't implement this interface directly! It's only
 * used by the caller and will be implemented by the framework on-the-fly.
 */
@ModulImplIntfRef(LoginModuleImplIntf.class)
public interface LoginModule extends Module {

    /**
     * Shows a login dialog with a preset user name and returns after the login
     * is done.
     * 
     * @param username
     *            Initial user name or <code>null</code>.
     * 
     * @return Name of the user that successfully logged in.
     * 
     * @throws CanceledException
     *             User canceled the login process.
     */
    @WaitForUserInput
    public String login(String username) throws CanceledException;

    /**
     * Shows a login dialog and returns after the login is done.
     * 
     * @return Name of the user that successfully logged in.
     * 
     * @throws CanceledException
     *             User canceled the login process.
     */
    @WaitForUserInput
    public String login() throws CanceledException;

}
