// CHECKSTYLE:OFF Generated Code
/*
 * Created by JFormDesigner on Sat Feb 27 16:46:29 CET 2010
 */

package org.fuin.examples.apps4swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Example login panel.
 */
public class LoginPanel extends JPanel implements LoginView {

	private static final long serialVersionUID = 1L;
	
	private static final Logger LOG = LoggerFactory.getLogger(LoginPanel.class);
			
	private LoginController ctrl;

	/**
	 * Default constructor.
	 */
	public LoginPanel() {
		initComponents();
		initHandler();
	}


	public JPanel getViewUI() {
		return this;
	}
	
	public LoginController getController() {
		return ctrl;
	}
	
	public void setController(LoginController ctrl) {
		this.ctrl = ctrl;
	}

	public void block() {
		// TODO Auto-generated method stub
	}

	public void unblock() {
		// TODO Auto-generated method stub
	}
	
	/**
	 * Returns the default button.
	 * 
	 * @return Default button.
	 */
	public JButton getDefaultButton() {
		return buttonOK;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setUsername(String username) {
		LOG.info("SET USERNAME '" + username + "'");
		textFieldUsername.setText(username);
	}

	/**
	 * {@inheritDoc}
	 */
	public void setMessage(String message) {
		LOG.info("SET MESSAGE '" + message + "'");
		labelMessage.setText(message);
	}

	/**
	 * Connect buttons with controller.
	 */
	private void initHandler() {
		buttonOK.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ctrl.verify(textFieldUsername.getText(), textFieldPassword
						.getPassword());
			}
		});
		buttonCancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ctrl.cancel();
			}
		});
		setPreferredSize(new Dimension(300, 200));
	}

	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY
		// //GEN-BEGIN:initComponents
		labelUsername = new JLabel();
		labelPassword = new JLabel();
		textFieldUsername = new JTextField();
		buttonOK = new JButton();
		buttonCancel = new JButton();
		textFieldPassword = new JPasswordField();
		labelLogIn = new JLabel();
		labelMessage = new JLabel();

		// ======== this ========
		setPreferredSize(new Dimension(400, 300));
		setName("this");
		setLayout(null);

		// ---- labelUsername ----
		labelUsername.setText("Username:");
		labelUsername.setName("labelUsername");
		add(labelUsername);
		labelUsername.setBounds(20, 40, 57, 19);

		// ---- labelPassword ----
		labelPassword.setText("Password:");
		labelPassword.setName("labelPassword");
		add(labelPassword);
		labelPassword.setBounds(20, 65, 59, 19);

		// ---- textFieldUsername ----
		textFieldUsername.setName("textFieldUsername");
		add(textFieldUsername);
		textFieldUsername.setBounds(85, 40, 160, textFieldUsername
				.getPreferredSize().height);

		// ---- buttonOK ----
		buttonOK.setText("OK");
		buttonOK.setName("buttonOK");
		add(buttonOK);
		buttonOK.setBounds(170, 115, 75, buttonOK.getPreferredSize().height);

		// ---- buttonCancel ----
		buttonCancel.setText("Cancel");
		buttonCancel.setName("buttonCancel");
		add(buttonCancel);
		buttonCancel.setBounds(90, 115, 75, 25);

		// ---- textFieldPassword ----
		textFieldPassword.setName("textFieldPassword");
		add(textFieldPassword);
		textFieldPassword.setBounds(85, 65, 160, textFieldPassword
				.getPreferredSize().height);

		// ---- labelLogIn ----
		labelLogIn.setText("Log In");
		labelLogIn.setFont(labelLogIn.getFont().deriveFont(
				labelLogIn.getFont().getStyle() | Font.BOLD,
				labelLogIn.getFont().getSize() + 5f));
		labelLogIn.setName("labelLogIn");
		add(labelLogIn);
		labelLogIn.setBounds(20, 5, 230, 20);

		// ---- labelMessage ----
		labelMessage.setForeground(Color.red);
		labelMessage.setHorizontalAlignment(SwingConstants.RIGHT);
		labelMessage.setText("error message");
		labelMessage.setName("labelMessage");
		add(labelMessage);
		labelMessage.setBounds(20, 90, 225, 20);

		{ // compute preferred size
			Dimension preferredSize = new Dimension();
			for (int i = 0; i < getComponentCount(); i++) {
				Rectangle bounds = getComponent(i).getBounds();
				preferredSize.width = Math.max(bounds.x + bounds.width,
						preferredSize.width);
				preferredSize.height = Math.max(bounds.y + bounds.height,
						preferredSize.height);
			}
			Insets insets = getInsets();
			preferredSize.width += insets.right;
			preferredSize.height += insets.bottom;
			setMinimumSize(preferredSize);
			setPreferredSize(preferredSize);
		}
		// JFormDesigner - End of component initialization
		// //GEN-END:initComponents
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY
	// //GEN-BEGIN:variables
	private JLabel labelUsername;
	private JLabel labelPassword;
	private JTextField textFieldUsername;
	private JButton buttonOK;
	private JButton buttonCancel;
	private JPasswordField textFieldPassword;
	private JLabel labelLogIn;
	private JLabel labelMessage;
	// JFormDesigner - End of variables declaration //GEN-END:variables


}
//CHECKSTYLE:ON
