/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.apps4pivot;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.log4j.PropertyConfigurator;
import org.fuin.apps4swing.ControllerViewConnector;
import org.fuin.examples.apps4xxxxx.LoginController;
import org.fuin.examples.apps4xxxxx.LoginControllerImpl;
import org.fuin.examples.apps4xxxxx.LoginView;

/**
 * Better approach using an easy framework to connect controller and view.
 */
public final class LoginDialogBetterApproach {

    private static ExecutorService createExecutorService() {
        final ExecutorService executorService = Executors.newCachedThreadPool();
        Runtime.getRuntime().addShutdownHook(new Thread() {
            @Override
            public void run() {
                // shutdown thread pool
                executorService.shutdown();
            }
        });
        return executorService;
    }

    /**
     * Run the application.
     */
    private void start() {

        // Create view
        final LoginView view = new LoginViewImpl();

        // Create controller
        final LoginController ctrl = new LoginControllerImpl();

        // Connect controller and view
        final ControllerViewConnector<LoginController, LoginView> cvc = new ControllerViewConnector<LoginController, LoginView>(
                "Login", "org.fuin.examples.apps4pivot.controller.generated",
                LoginController.class, ctrl, "org.fuin.examples.apps4pivot.view.generated",
                LoginView.class, view, createExecutorService(), 4);

        // Call cancel on Window closing
        final LoginController ctrlQueue = cvc.getControllerQueue();
        // TODO Implement!

    }

    private static void configureLog4J() {
        final Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO, A1");
        props.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.A1.layout.ConversionPattern",
                "%d{HH:mm:ss,SSS} [%-20t] %-5p %-40c{1} - %m%n");
        PropertyConfigurator.configure(props);
    }

    /**
     * Starts the example.
     * 
     * @param args
     *            Not used.
     */
    public static void main(final String[] args) {
        configureLog4J();
        new LoginDialogBetterApproach().start();
    }

}
