/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.examples.kickstart4j;

import java.io.File;
import java.io.IOException;
import org.fuin.kickstart4j.Config;
import org.fuin.kickstart4j.ConfigParser;
import org.fuin.kickstart4j.InvalidConfigException;
import org.fuin.kickstart4j.MkDir;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.utils4j.Utils4J;

public final class CreateConfigExample {
    private static final boolean UNZIP = true;
    private static final boolean DONT_UNZIP = false;
    private static final boolean LOAD_ALWAYS = true;
    private static final boolean ADD_TO_CLASSPATH = true;
    private static final boolean DONT_ADD_TO_CLASSPATH = false;

    private CreateConfigExample() {
        throw new UnsupportedOperationException("It's not allowed to create an instance of this class!");
    }

    public static void main(String[] args) throws IOException, InvalidConfigException {
        File configFile = new File("src/main/kickstart4j/example.xml");
        Config config = ConfigParser.create((File)configFile);
        config.setIdFilename(".org-fuin-examples-SwingSet2");
        config.setDestPath("c:/fuin.org/examples/swingset2");
        config.setJavaExe("jre6/bin/java.exe");
        config.setJavaArgs("-classpath ${classpath} SwingSet2");
        config.setTitle("Kickstart4J SwingSet2");
        config.setVendor("Future Invent Informationsmanagement GmbH");
        config.setDescription("Local installed SwingSet2 with it's own Java Runtime 1.6");
        config.setLogFilename("${destDir}/logs/kickstart.log");
        config.setVersion("0.1.0");
        config.getSrcFiles().clear();
        config.getSrcDirs().clear();
        config.getMkDirs().clear();
        File swingSet2Jar = new File("src/main/kickstart4j/SwingSet2.jar");
        SrcFile swingSet2SrcFile = new SrcFile("lib", "SwingSet2.jar", Utils4J.createHash((File)swingSet2Jar), swingSet2Jar.length(), false, true, true, "http://www.fuin.org/examples/kickstart4j/SwingSet2.jar");
        config.getSrcFiles().add(swingSet2SrcFile);
        File jre6Zip = new File("src/main/kickstart4j/jre6.zip");
        SrcFile jre6SrcFile = new SrcFile("", "jre6.zip", Utils4J.createHash((File)jre6Zip), jre6Zip.length(), true, true, false, "http://www.fuin.org/examples/kickstart4j/jre6.zip");
        config.getSrcFiles().add(jre6SrcFile);
        config.getMkDirs().add(new MkDir("logs"));
        config.writeToVarXML(configFile, false);
        System.out.println("CREATED " + configFile.getCanonicalPath());
    }
}

