/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.examples.utils4swing.common;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;

/**
 * Example showing how to center a panel on the screen.
 */
public final class CreateShowAndPositionExample extends JPanel {

	private static final long serialVersionUID = 1L;

	/**
	 * Default constructor.
	 */
	public CreateShowAndPositionExample() {
		super();
		setPreferredSize(new Dimension(400, 300));
		setLayout(new BorderLayout());
		add(new JLabel("Hello world!", SwingConstants.CENTER),
				BorderLayout.CENTER);
	}

	/**
	 * Starts the panel for a short test.
	 * 
	 * @param args
	 *            Not used.
	 */
	public static void main(final String[] args) {

		SwingUtilities.invokeLater(new Runnable() {
			public void run() {

				// Initialize the system LnF without ugly "try catch"
				Utils4Swing.initSystemLookAndFeel();

				// Create a frame using the "preferred size" of the panel and
				// show it centered on the screen with a single line of code...
				Utils4Swing.createShowAndPosition("Example",
						new CreateShowAndPositionExample(), true,
						new ScreenCenterPositioner());

			}
		});

	}

}
